------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
------------------------------------------------------------------
PACKAGE stack_types IS
  TYPE data_type IS ARRAY(0 TO 7) OF std_logic; -- line 1

  TYPE element_rec;  -- incomplete type  line 2

  TYPE element_ptr IS ACCESS element_rec; -- line 3
  TYPE element_rec IS    -- line 4
    RECORD               -- line 5
      data : data_type;  -- line 6
      nxt  : element_ptr;-- line 7
    END RECORD;          -- line 8

END stack_types;

------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
------------------------------------------------------------------
USE WORK.stack_types.ALL;
ENTITY stack IS
  PORT(din : IN data_type;
       clk : IN std_logic;
       dout : OUT data_type;
       r_wb : IN std_logic);
END stack;

ARCHITECTURE stack OF stack IS
BEGIN
  PROCESS(clk)

    VARIABLE list_head : element_ptr := NULL;-- line 9
    VARIABLE temp_elem : element_ptr := NULL;-- line 10
    VARIABLE last_clk : std_logic    := 'U';   -- line 11
 BEGIN
    IF (clk = '1') AND (last_clk = '0') THEN -- line 12
      IF (r_wb = '0') THEN           --  line 13
        temp_elem := NEW element_rec; -- line 14
        temp_elem.data := din;        -- line 15
        temp_elem.nxt := list_head;   -- line 16
        list_head := temp_elem;       -- line 17
        -- read mode                     line 18
      ELSIF (r_wb = '1') THEN
        dout <= list_head.data;       -- line 19
        temp_elem := list_head;       -- line 20
        list_head := temp_elem.nxt;   -- line 21
        DEALLOCATE (temp_elem);       -- line 22
      ELSE
        ASSERT FALSE
          REPORT "read/write unknown while clock active"
          SEVERITY WARNING;           -- line 23
      END IF;
    END IF;
    last_clk := clk;                  -- line 24
  END PROCESS;
END stack;


